﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Inet.Viewer.WinForms.Prompt
{
    /// <summary>
    /// A combobox which has (almost) the visual appearance of a regular textbox when the style
    /// is set to simple and no entries are inserted.
    /// </summary>
    public partial class PromptComboBox : ComboBox
    {
        /// <inheritdoc/>
        protected override void WndProc(ref Message m)
        {
            base.WndProc(ref m);
            if (m.Msg == 0x000F && DropDownStyle == ComboBoxStyle.Simple && !Focused)
            {
                Graphics g = Graphics.FromHwnd(Handle);
                Rectangle bounds = new Rectangle(0, 0, Width, Height);
                ControlPaint.DrawBorder3D(g, bounds, Border3DStyle.SunkenInner);
            }
        }
    }
}
